//=============================================================================
// ChallengeHUD - modified by TheDane to show the statistic info
//=============================================================================
class DM_HUD extends ChallengeHUD;

var FontInfo FI;
var StatsInfo I;
var Pawn playerOwner;
var int ShowNow;
var int TTime, AddDrawTime, AddColor, ColorFade, ColorShowTime;

simulated function DrawWeapons(Canvas Canvas)
{
	local int ownerId;
	local float XL, YL, Y;
	local int ResultEFF;
	local float ResA, ResB;
	local bool bJustOnce, bFadingUp, bFadingDown, bNext, bShow;
	local string prefix;

	// original vars:
	local Weapon W, WeaponSlot[11];
	local inventory Inv;
	local int i, j, BaseY, BaseX, Pending, WeapX, WeapY;
	local float AmmoScale, WeaponOffset, WeapScale, WeaponX, TexX, TexY;


	//if (playerOwner != None && I != None && FI != None)
		//{	
		ownerId = playerOwner.PlayerReplicationInfo.PlayerID;
		
		Canvas.Reset();
		Canvas.Font = Font'Botpack.WhiteFont';
		//C.DrawColor = WhiteColor;
		Canvas.TextSize("TEST", XL, YL);
		Canvas.Style = Style;
		Y = Canvas.ClipY / 2 - YL * 5.5;

		if ( TTime == 120 )
			{
			AddDrawTime = 1;
			}
		else
			{
			TTime++;
			}
		if ( AddDrawTime == 1 )
			{
			Canvas.DrawColor.R = AddColor;
			Canvas.DrawColor.G = AddColor;
			Canvas.DrawColor.B = AddColor;
			if ( ColorFade == 0 )
				{
				AddColor += 3;
				if ( AddColor >= 255 )
					{
					AddColor = 255;
					ColorShowTime++;
					if ( ColorShowTime == 250 )
						{
						ColorFade = 1;
						}
					}
				}
		
			else if ( ColorFade == 1 )
				{
				AddColor -= 3;
				if ( AddColor <= 0 )
					{
					AddColor = 0;
					ColorFade = 0;
					ColorShowTime = 0;
					//ColorFade = 0;
					//TTime = 0;
					ShowNow++;
					if ( ShowNow >= 11 )
						{
						ShowNow = 0;
						}
					}
				}
			}
	

		if ( ShowNow == 10 )
			{
			Canvas.SetPos(0, Y);
			Canvas.DrawText("TheDanes Statistics");
			Canvas.SetPos(0, Y += YL * 2);
			Canvas.DrawText("By TheDane");
			Canvas.SetPos(0, Y += YL * 2);
			Canvas.DrawText("www.thedanesjoint.com");
			}
		else
			{
			if ( ShowNow == 0 )
				{
				prefix = "st";
				}
			else if ( ShowNow == 1 )
				{
				prefix = "nd";
				}
			else if ( ShowNow == 2 )
				{
				prefix = "rd";
				}
			else
				{
				prefix = "th";
				}
			Canvas.SetPos(0, Y);
			Canvas.DrawText("Player: "$I.SP[ShowNow]);
			Canvas.SetPos(0, Y += YL);
			Canvas.DrawText("Ranking: "$ShowNow+1$prefix);
			Canvas.SetPos(0, Y += YL);
			Canvas.DrawText("Frags: "$I.SF[ShowNow]);
			Canvas.SetPos(0, Y += YL);
			Canvas.DrawText("Deaths: "$I.SD[ShowNow]);
			Canvas.SetPos(0, Y += YL);
			Canvas.DrawText("Games: "$I.SG[ShowNow]);
			// udregn eff
			ResA = I.SF[ShowNow];
			if (ResA < 0)
				{
				ResA = 0;
				}
			ResB = ResA;
			ResA += I.SD[ShowNow];
			ResB /=ResA;
			ResB *=100;
			ResultEFF = ResB;
			// slut udregn eff
			Canvas.SetPos(0, Y += YL);
			Canvas.DrawText("Eff: "$ResultEFF$"%");
			}
		
		//}

	//original script

	BaseX = 0.5 * (Canvas.ClipX - HudScale * WeaponScale * Canvas.ClipX);
	WeapScale = WeaponScale * Scale;
	Canvas.Style = Style;
	BaseY = Canvas.ClipY - 63.5 * WeapScale;
	WeaponOffset = 0.1 * HUDScale * WeaponScale * Canvas.ClipX;

	if ( PawnOwner.Weapon != None )
	{
		W = PawnOwner.Weapon;
		if ( (Opacity > 8) || !Level.bHighDetailMode )
			Canvas.Style = ERenderStyle.STY_Normal;
		WeaponX = BaseX + (W.InventoryGroup - 1) * WeaponOffset;
		Canvas.CurX = WeaponX;
		Canvas.CurY = BaseY;
		Canvas.DrawColor = SolidHUDColor;
		Canvas.DrawIcon(W.StatusIcon, WeapScale);
		Canvas.DrawColor = GoldColor;
		Canvas.CurX = WeaponX + 4 * WeapScale;
		Canvas.CurY = BaseY + 4 * WeapScale;
		Canvas.Style = Style;
		if ( W.InventoryGroup == 10 )
			Canvas.DrawTile(Texture'BotPack.HudElements1', 0.75 * WeapScale * 25, 0.75 * WeapScale * 64, 0, 0, 25.0, 64.0);
		else
			Canvas.DrawTile(Texture'BotPack.HudElements1', 0.75 * WeapScale * 25, 0.75 * WeapScale * 64, 25*W.InventoryGroup, 0, 25.0, 64.0);

		WeaponSlot[W.InventoryGroup] = W;  
		Canvas.CurX = WeaponX;
		Canvas.CurY = BaseY;
		Canvas.DrawTile(Texture'BotPack.HUDWeapons', 128 * WeapScale, 64 * WeapScale, 128, 64, 128, 64);
	}
	if ( Level.bHighDetailMode && (PawnOwner.PendingWeapon != None) )
	{
		Pending = PawnOwner.PendingWeapon.InventoryGroup;
		Canvas.CurX = BaseX + (Pending - 1) * WeaponOffset - 64 * WeapScale;
		Canvas.CurY = Canvas.ClipY - 96 * WeapScale; 
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = GoldColor;
		Canvas.DrawTile(Texture'BotPack.HUDWeapons', 256 * WeapScale, 128 * WeapScale, 0, 128, 256.0, 128.0);
	}
	else
		Pending = 100;

	Canvas.Style = Style;
	i = 0;
	for ( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Inv.IsA('Weapon') && (Inv != PawnOwner.Weapon) )
		{
			W = Weapon(Inv);
			if ( WeaponSlot[W.InventoryGroup] == None )
				WeaponSlot[W.InventoryGroup] = W;
			else if ( (WeaponSlot[W.InventoryGroup] != PawnOwner.Weapon)
					&& ((W == PawnOwner.PendingWeapon) || (WeaponSlot[W.InventoryGroup].AutoSwitchPriority < W.AutoSwitchPriority)) )
				WeaponSlot[W.InventoryGroup] = W;
		}
		i++;
		if ( i > 100 )
			break; // can occasionally get temporary loops in netplay
	}
	W = PawnOwner.Weapon;

	// draw weapon list
	TexX = 128 * WeapScale;
	TexY = 64 * WeapScale;
	for ( i=1; i<11; i++ )
	{
		if ( WeaponSlot[i] == None )
		{
			Canvas.Style = Style;
			Canvas.DrawColor =  0.5 * HUDColor;
			Canvas.CurX = BaseX + (i - 1) * WeaponOffset;
			Canvas.CurY = BaseY;
			
			WeapX = ((i-1)%4) * 64;
			WeapY = ((i-1)/4) * 32;
			Canvas.DrawTile(Texture'BotPack.HUDWeapons',TexX,TexY,WeapX,WeapY,64.0,32.0);
		}
		else if ( WeaponSlot[i] != W )
		{
			if ( Pending == i )
			{
				if ( (Opacity > 8) || !Level.bHighDetailMode )
					Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor = SolidHUDColor;
			}
			else
			{
				Canvas.Style = Style;
				Canvas.DrawColor = 0.5 * HUDColor;
			}
			Canvas.CurX = BaseX + (i - 1) * WeaponOffset;
			Canvas.CurY = BaseY;
			
			if ( WeaponSlot[i].bSpecialIcon )
				Canvas.DrawIcon(WeaponSlot[i].StatusIcon, WeapScale);
			else
			{
				WeapX = ((i-1)%4) * 64;
				WeapY = ((i-1)/4) * 32;
				Canvas.DrawTile(Texture'BotPack.HUDWeapons',TexX,TexY,WeapX,WeapY,64.0,32.0);
			}
		}
	}

	//draw weapon numbers and ammo
	TexX = 0.75 * WeapScale * 25;
	TexY = 0.75 * WeapScale * 64;
	for ( i=1; i<11; i++ )
	{
		if ( WeaponSlot[i] != None )
		{
			WeaponX = BaseX + (i - 1) * WeaponOffset + 4 * WeapScale;
			if ( WeaponSlot[i] != W )
			{
				Canvas.CurX = WeaponX;
				Canvas.CurY = BaseY + 4 * WeapScale;
				Canvas.DrawColor = GoldColor;
				if ( (Opacity > 8) || !Level.bHighDetailMode )
					Canvas.Style = ERenderStyle.STY_Normal;
				else
					Canvas.Style = Style;
				if ( i == 10 )
					Canvas.DrawTile(Texture'BotPack.HudElements1', TexX, TexY, 0, 0, 25.0, 64.0);
				else
					Canvas.DrawTile(Texture'BotPack.HudElements1', TexX, TexY, 25*i, 0, 25.0, 64.0);
			}
			if ( WeaponSlot[i].AmmoType != None )
			{
				// Draw Ammo bar
				Canvas.CurX = WeaponX;
				Canvas.CurY = BaseY + 52 * WeapScale;
				Canvas.DrawColor = BaseColor;
				AmmoScale = FClamp(88.0 * WeapScale * WeaponSlot[i].AmmoType.AmmoAmount/WeaponSlot[i].AmmoType.MaxAmmo, 0, 88);
				Canvas.DrawTile(Texture'BotPack.HudElements1', AmmoScale, 8 * WeapScale,64,64,128.0,8.0);
			}
		}
	}

}

